#!/bin/bash
#SBATCH --mem=10G
#SBATCH --cpus-per-task=5
#SBATCH --time=5:00:00
#SBATCH --output=/scratch/shared/beegfs/yuki/fast/slurm/person/yfcc-noface-%a.out
#SBACTH --open-mode=append
#SBATCH --gres=gpu:1
#SBATCH --partition=gpu
#SBACTH --open-mode=append
#SBATCH --job-name=persondet
#SBATCH --exclude=gnodec1,gnodee1
#SBATCH --array=0-175%45



echo $SLURM_ARRAY_TASK_ID
X=$((${SLURM_ARRAY_TASK_ID}*80000))
Y=$(((${SLURM_ARRAY_TASK_ID} + 1)*80000))

in_file=_tmp_yfcc-noface_${SLURM_ARRAY_TASK_ID}.txt
rm ${in_file}
results_dir='/scratch/shared/beegfs/yuki/fast/yfcc-noface/person/'
mkdir -p ${results_dir}
< /scratch/shared/beegfs/yuki/data/YFCC-17M-noface.txt tail -n +"$X" | head -n "$((Y - X))" >> ${in_file}

echo "from " ${X}
echo "to " ${Y}

# ETA 4-6Hz
/scratch/shared/beegfs/yuki/envs/py37/bin/python3 -W ignore main_person_detector.py \
  --img_list=${in_file} \
  --save_folder=${results_dir}